def ackermann(m, n, indentation=None):
    if indentation is None:
        indentation = 0
    print('%sackermann(%s, %s)' % (' ' * indentation, m, n))

    if m == 0:
        # PRZYPADEK BAZOWY
        return n + 1
    elif m > 0 and n == 0:
        # PRZYPADEK REKURENCYJNY
        return ackermann(m - 1, 1, indentation + 1)
    elif m > 0 and n > 0:
        # PRZYPADEK REKURENCYJNY
        return ackermann(m - 1, ackermann(m, n - 1, indentation + 1), indentation + 1)

print('Rozpoczynam od m = 1, n = 1:')
print(ackermann(1, 1))
print('Rozpoczynam od m = 2, n = 3:')
print(ackermann(2, 3))
